//+------------------------------------------------------------------+
//|                                                 Account Info.mq4 |
//|                                                  Sergey Mechanic |
//|        https://login.mql5.com/ru/users/sergey_mechanic/portfolio |
//+------------------------------------------------------------------+
#property copyright "Sergey Mechanic"
#property link      "https://login.mql5.com/ru/users/sergey_mechanic/portfolio"
#property version   "1.00"

void OnStart()
{
    //   : 0 -  , 1 -       
    string StopoutUnits;
   
    int StopoutMode = AccountStopoutMode();
    
    if(StopoutMode == 0)
        StopoutUnits = "(equity / used margin * 100):";
    else
        StopoutUnits = "(stopout mode = 1):\t";
        
    string AccountType;
    
    if(IsDemo() == true)
        AccountType = "Demo";
    else
        AccountType = "Real";
    
   
    string AccountInfo =    "Account number:\t\t" + DoubleToStr(AccountNumber(), 0)       + "\n" +
                            "Account type:\t\t"   + AccountType                           + "\n" +
                            "Account owner:\t\t"  + AccountName()                         + "\n" +                          
                            "Company:\t\t\t"      + AccountCompany()                      + "\n" +
                            "Server:\t\t\t"       + AccountServer()                       + "\n" +
                            "Currency:\t\t\t"     + AccountCurrency()                     + "\n" +
                            "Leverage:\t\t\t"     + DoubleToStr(AccountLeverage(), 0)     + "\n\n" +
                    
                            "Balance:\t\t\t"      + DoubleToStr(AccountBalance(), 2)      + "\n" +
                            "Equity:\t\t\t"       + DoubleToStr(AccountEquity(), 2)       + "\n" +
                            "Floating profit:\t\t"+ DoubleToStr(AccountProfit(), 2)       + "\n" +                 
                            "Used margin:\t\t"    + DoubleToStr(AccountMargin(), 2)       + "\n" +
                            "Free margin:\t\t"    + DoubleToStr(AccountFreeMargin(), 2)   + "\n" +                
                            "Credit:\t\t\t"       + DoubleToStr(AccountCredit(), 2)       + "\n\n" +
                            
                            "Stopout"                                               + "\n" +
                            StopoutUnits + "\t"  + DoubleToStr(AccountStopoutLevel(), 0);

                    
	MessageBox(AccountInfo, "Account Information", MB_OK);
	
	return;
}

